%------------------------------------------------------------------------------
% File     : DAT201^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Sorted list operations 70
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Lam09] Lammich (2009), Collections Framework
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : sorted_list_operations__70.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.1.0
% Syntax   : Number of formulae    :  315 (  47 unt;  37 typ;   0 def)
%            Number of atoms       :  923 ( 176 equ;   0 cnn)
%            Maximal formula atoms :   13 (   3 avg)
%            Number of connectives : 3910 (  85   ~;  17   |;  62   &;3238   @)
%                                         (   0 <=>; 508  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   21 (   9 avg)
%            Number of types       :    2 (   1 usr)
%            Number of type conns  :  116 ( 116   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   37 (  36 usr;   6 con; 0-3 aty)
%            Number of variables   : 1007 (  62   ^; 886   !;  32   ?;1007   :)
%                                         (  27  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:40:32.031
%------------------------------------------------------------------------------
%----Could-be-implicit typings (4)
thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (33)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Olattice,type,
    lattice: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Ono__bot,type,
    no_bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Ono__top,type,
    no_top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Odense__order,type,
    dense_order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Osemilattice__inf,type,
    semilattice_inf: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Conditionally__Complete__Lattices_Oconditionally__complete__linorder,type,
    condit1037483654norder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Lattices_Oinf__class_Oinf,type,
    inf_inf: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olinorder__class_Osorted,type,
    linorder_sorted: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : ( list @ A ) ).

thf(sy_c_List_Olist_Oset,type,
    set2: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Ounion,type,
    union: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Sorted__List__Operations__Mirabelle__fineeiboro_Ointer__sorted,type,
    sorted2037043510sorted: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_l1,type,
    l1: list @ a ).

thf(sy_v_l1a____,type,
    l1a: list @ a ).

thf(sy_v_l2,type,
    l2: list @ a ).

thf(sy_v_l2b____,type,
    l2b: list @ a ).

thf(sy_v_x1____,type,
    x1: a ).

thf(sy_v_x2____,type,
    x2: a ).

%----Relevant facts (256)
thf(fact_0_x1__neq__x2,axiom,
    x1 != x2 ).

% x1_neq_x2
thf(fact_1_x2__le__x1,axiom,
    ~ ( ord_less @ a @ x1 @ x2 ) ).

% x2_le_x1
thf(fact_2_x2__nin__l2,axiom,
    ~ ( member @ a @ x2 @ ( set2 @ a @ l2b ) ) ).

% x2_nin_l2
thf(fact_3_x1__le,axiom,
    ! [X: a] :
      ( ( member @ a @ X @ ( set2 @ a @ l1a ) )
     => ( ord_less_eq @ a @ x1 @ X ) ) ).

% x1_le
thf(fact_4_l1__OK,axiom,
    ( ( distinct @ a @ l1 )
    & ( linorder_sorted @ a @ l1 ) ) ).

% l1_OK
thf(fact_5_l2__OK,axiom,
    ( ( distinct @ a @ l2 )
    & ( linorder_sorted @ a @ l2 ) ) ).

% l2_OK
thf(fact_6_x2__le,axiom,
    ! [X: a] :
      ( ( member @ a @ X @ ( set2 @ a @ l2b ) )
     => ( ord_less_eq @ a @ x2 @ X ) ) ).

% x2_le
thf(fact_7_x1__l1__props,axiom,
    ( ( distinct @ a @ ( cons @ a @ x1 @ l1a ) )
    & ( linorder_sorted @ a @ ( cons @ a @ x1 @ l1a ) ) ) ).

% x1_l1_props
thf(fact_8_x2__l2__props,axiom,
    ( ( distinct @ a @ ( cons @ a @ x2 @ l2b ) )
    & ( linorder_sorted @ a @ ( cons @ a @ x2 @ l2b ) ) ) ).

% x2_l2_props
thf(fact_9_l1__props,axiom,
    ( ( distinct @ a @ l1a )
    & ( linorder_sorted @ a @ l1a ) ) ).

% l1_props
thf(fact_10_l2__props,axiom,
    ( ( distinct @ a @ l2b )
    & ( linorder_sorted @ a @ l2b ) ) ).

% l2_props
thf(fact_11_ind__hyp__l2,axiom,
    ( ( distinct @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b ) )
    & ( linorder_sorted @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b ) )
    & ( ( set2 @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b ) )
      = ( inf_inf @ ( set @ a ) @ ( set2 @ a @ ( cons @ a @ x1 @ l1a ) ) @ ( set2 @ a @ l2b ) ) ) ) ).

% ind_hyp_l2
thf(fact_12_x1__nin__l1,axiom,
    ~ ( member @ a @ x1 @ ( set2 @ a @ l1a ) ) ).

% x1_nin_l1
thf(fact_13_x2__less__x1,axiom,
    ord_less @ a @ x2 @ x1 ).

% x2_less_x1
thf(fact_14_Cons_Ohyps,axiom,
    ( ( ( distinct @ a @ l2b )
      & ( linorder_sorted @ a @ l2b ) )
   => ( ( distinct @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b ) )
      & ( linorder_sorted @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b ) )
      & ( ( set2 @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ l2b ) )
        = ( inf_inf @ ( set @ a ) @ ( set2 @ a @ ( cons @ a @ x1 @ l1a ) ) @ ( set2 @ a @ l2b ) ) ) ) ) ).

% Cons.hyps
thf(fact_15_ind__hyp__l1,axiom,
    ! [L2: list @ a] :
      ( ( ( distinct @ a @ L2 )
        & ( linorder_sorted @ a @ L2 ) )
     => ( ( distinct @ a @ ( sorted2037043510sorted @ a @ l1a @ L2 ) )
        & ( linorder_sorted @ a @ ( sorted2037043510sorted @ a @ l1a @ L2 ) )
        & ( ( set2 @ a @ ( sorted2037043510sorted @ a @ l1a @ L2 ) )
          = ( inf_inf @ ( set @ a ) @ ( set2 @ a @ l1a ) @ ( set2 @ a @ L2 ) ) ) ) ) ).

% ind_hyp_l1
thf(fact_16_sorted__distinct__set__unique,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,Ys: list @ A] :
          ( ( linorder_sorted @ A @ Xs )
         => ( ( distinct @ A @ Xs )
           => ( ( linorder_sorted @ A @ Ys )
             => ( ( distinct @ A @ Ys )
               => ( ( ( set2 @ A @ Xs )
                    = ( set2 @ A @ Ys ) )
                 => ( Xs = Ys ) ) ) ) ) ) ) ).

% sorted_distinct_set_unique
thf(fact_17_distinct_Osimps_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ X @ Xs ) )
      = ( ~ ( member @ A @ X @ ( set2 @ A @ Xs ) )
        & ( distinct @ A @ Xs ) ) ) ).

% distinct.simps(2)
thf(fact_18_inter__sorted_Osimps_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X1: A,X2: A,L1: list @ A,L2: list @ A] :
          ( ( ( ord_less @ A @ X1 @ X2 )
           => ( ( sorted2037043510sorted @ A @ ( cons @ A @ X1 @ L1 ) @ ( cons @ A @ X2 @ L2 ) )
              = ( sorted2037043510sorted @ A @ L1 @ ( cons @ A @ X2 @ L2 ) ) ) )
          & ( ~ ( ord_less @ A @ X1 @ X2 )
           => ( ( ( X1 = X2 )
               => ( ( sorted2037043510sorted @ A @ ( cons @ A @ X1 @ L1 ) @ ( cons @ A @ X2 @ L2 ) )
                  = ( cons @ A @ X1 @ ( sorted2037043510sorted @ A @ L1 @ L2 ) ) ) )
              & ( ( X1 != X2 )
               => ( ( sorted2037043510sorted @ A @ ( cons @ A @ X1 @ L1 ) @ ( cons @ A @ X2 @ L2 ) )
                  = ( sorted2037043510sorted @ A @ ( cons @ A @ X1 @ L1 ) @ L2 ) ) ) ) ) ) ) ).

% inter_sorted.simps(3)
thf(fact_19_IntI,axiom,
    ! [A: $tType,C: A,A2: set @ A,B: set @ A] :
      ( ( member @ A @ C @ A2 )
     => ( ( member @ A @ C @ B )
       => ( member @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B ) ) ) ) ).

% IntI
thf(fact_20_Int__iff,axiom,
    ! [A: $tType,C: A,A2: set @ A,B: set @ A] :
      ( ( member @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B ) )
      = ( ( member @ A @ C @ A2 )
        & ( member @ A @ C @ B ) ) ) ).

% Int_iff
thf(fact_21_inf__apply,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( semilattice_inf @ B2 @ ( type2 @ B2 ) )
     => ( ( inf_inf @ ( A > B2 ) )
        = ( ^ [F: A > B2,G: A > B2,X3: A] : ( inf_inf @ B2 @ ( F @ X3 ) @ ( G @ X3 ) ) ) ) ) ).

% inf_apply
thf(fact_22_inf_Oidem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A] :
          ( ( inf_inf @ A @ A3 @ A3 )
          = A3 ) ) ).

% inf.idem
thf(fact_23_inf__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ( ( inf_inf @ A @ X @ X )
          = X ) ) ).

% inf_idem
thf(fact_24_inf_Oleft__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( inf_inf @ A @ A3 @ ( inf_inf @ A @ A3 @ B3 ) )
          = ( inf_inf @ A @ A3 @ B3 ) ) ) ).

% inf.left_idem
thf(fact_25_inf__left__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ X @ Y ) )
          = ( inf_inf @ A @ X @ Y ) ) ) ).

% inf_left_idem
thf(fact_26_inf_Oright__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ A3 @ B3 ) @ B3 )
          = ( inf_inf @ A @ A3 @ B3 ) ) ) ).

% inf.right_idem
thf(fact_27_inf__right__idem,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X @ Y ) @ Y )
          = ( inf_inf @ A @ X @ Y ) ) ) ).

% inf_right_idem
thf(fact_28_list_Oinject,axiom,
    ! [A: $tType,X21: A,X22: list @ A,Y21: A,Y22: list @ A] :
      ( ( ( cons @ A @ X21 @ X22 )
        = ( cons @ A @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 ) ) ) ).

% list.inject
thf(fact_29_inf_Obounded__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) )
          = ( ( ord_less_eq @ A @ A3 @ B3 )
            & ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% inf.bounded_iff
thf(fact_30_le__inf__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ ( inf_inf @ A @ Y @ Z ) )
          = ( ( ord_less_eq @ A @ X @ Y )
            & ( ord_less_eq @ A @ X @ Z ) ) ) ) ).

% le_inf_iff
thf(fact_31_sorted__many__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Zs: list @ A] :
          ( ( linorder_sorted @ A @ ( cons @ A @ X @ ( cons @ A @ Y @ Zs ) ) )
          = ( ( ord_less_eq @ A @ X @ Y )
            & ( linorder_sorted @ A @ ( cons @ A @ Y @ Zs ) ) ) ) ) ).

% sorted_many_eq
thf(fact_32_inf_Ostrict__coboundedI2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B3: A,C: A,A3: A] :
          ( ( ord_less @ A @ B3 @ C )
         => ( ord_less @ A @ ( inf_inf @ A @ A3 @ B3 ) @ C ) ) ) ).

% inf.strict_coboundedI2
thf(fact_33_inf_Ostrict__coboundedI1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,C: A,B3: A] :
          ( ( ord_less @ A @ A3 @ C )
         => ( ord_less @ A @ ( inf_inf @ A @ A3 @ B3 ) @ C ) ) ) ).

% inf.strict_coboundedI1
thf(fact_34_inf_Ostrict__order__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [A4: A,B4: A] :
              ( ( A4
                = ( inf_inf @ A @ A4 @ B4 ) )
              & ( A4 != B4 ) ) ) ) ) ).

% inf.strict_order_iff
thf(fact_35_inf_Ostrict__boundedE,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) )
         => ~ ( ( ord_less @ A @ A3 @ B3 )
             => ~ ( ord_less @ A @ A3 @ C ) ) ) ) ).

% inf.strict_boundedE
thf(fact_36_less__infI2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B3: A,X: A,A3: A] :
          ( ( ord_less @ A @ B3 @ X )
         => ( ord_less @ A @ ( inf_inf @ A @ A3 @ B3 ) @ X ) ) ) ).

% less_infI2
thf(fact_37_less__infI1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,X: A,B3: A] :
          ( ( ord_less @ A @ A3 @ X )
         => ( ord_less @ A @ ( inf_inf @ A @ A3 @ B3 ) @ X ) ) ) ).

% less_infI1
thf(fact_38_inf_OcoboundedI2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B3: A,C: A,A3: A] :
          ( ( ord_less_eq @ A @ B3 @ C )
         => ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ C ) ) ) ).

% inf.coboundedI2
thf(fact_39_inf_OcoboundedI1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,C: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ C )
         => ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ C ) ) ) ).

% inf.coboundedI1
thf(fact_40_inf_Oabsorb__iff2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [B4: A,A4: A] :
              ( ( inf_inf @ A @ A4 @ B4 )
              = B4 ) ) ) ) ).

% inf.absorb_iff2
thf(fact_41_inf_Oabsorb__iff1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A4: A,B4: A] :
              ( ( inf_inf @ A @ A4 @ B4 )
              = A4 ) ) ) ) ).

% inf.absorb_iff1
thf(fact_42_inf_Ocobounded2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ B3 ) ) ).

% inf.cobounded2
thf(fact_43_inf_Ocobounded1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ A3 ) ) ).

% inf.cobounded1
thf(fact_44_inf_Oorder__iff,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A4: A,B4: A] :
              ( A4
              = ( inf_inf @ A @ A4 @ B4 ) ) ) ) ) ).

% inf.order_iff
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A3: A,P: A > $o] :
      ( ( member @ A @ A3 @ ( collect @ A @ P ) )
      = ( P @ A3 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( collect @ A
        @ ^ [X3: A] : ( member @ A @ X3 @ A2 ) )
      = A2 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X4: A] :
          ( ( P @ X4 )
          = ( Q @ X4 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B2: $tType,A: $tType,F2: A > B2,G2: A > B2] :
      ( ! [X4: A] :
          ( ( F2 @ X4 )
          = ( G2 @ X4 ) )
     => ( F2 = G2 ) ) ).

% ext
thf(fact_49_inf__greatest,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ X @ Z )
           => ( ord_less_eq @ A @ X @ ( inf_inf @ A @ Y @ Z ) ) ) ) ) ).

% inf_greatest
thf(fact_50_inf_OboundedI,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ A3 @ C )
           => ( ord_less_eq @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) ) ) ) ) ).

% inf.boundedI
thf(fact_51_inf_OboundedE,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) )
         => ~ ( ( ord_less_eq @ A @ A3 @ B3 )
             => ~ ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% inf.boundedE
thf(fact_52_inf__absorb2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ( ( inf_inf @ A @ X @ Y )
            = Y ) ) ) ).

% inf_absorb2
thf(fact_53_inf__absorb1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( inf_inf @ A @ X @ Y )
            = X ) ) ) ).

% inf_absorb1
thf(fact_54_inf_Oabsorb2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( inf_inf @ A @ A3 @ B3 )
            = B3 ) ) ) ).

% inf.absorb2
thf(fact_55_inf_Oabsorb1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( inf_inf @ A @ A3 @ B3 )
            = A3 ) ) ) ).

% inf.absorb1
thf(fact_56_le__iff__inf,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [X3: A,Y2: A] :
              ( ( inf_inf @ A @ X3 @ Y2 )
              = X3 ) ) ) ) ).

% le_iff_inf
thf(fact_57_inf__unique,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [F2: A > A > A,X: A,Y: A] :
          ( ! [X4: A,Y3: A] : ( ord_less_eq @ A @ ( F2 @ X4 @ Y3 ) @ X4 )
         => ( ! [X4: A,Y3: A] : ( ord_less_eq @ A @ ( F2 @ X4 @ Y3 ) @ Y3 )
           => ( ! [X4: A,Y3: A,Z2: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y3 )
                 => ( ( ord_less_eq @ A @ X4 @ Z2 )
                   => ( ord_less_eq @ A @ X4 @ ( F2 @ Y3 @ Z2 ) ) ) )
             => ( ( inf_inf @ A @ X @ Y )
                = ( F2 @ X @ Y ) ) ) ) ) ) ).

% inf_unique
thf(fact_58_inf_OorderI,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( A3
            = ( inf_inf @ A @ A3 @ B3 ) )
         => ( ord_less_eq @ A @ A3 @ B3 ) ) ) ).

% inf.orderI
thf(fact_59_inf_OorderE,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( A3
            = ( inf_inf @ A @ A3 @ B3 ) ) ) ) ).

% inf.orderE
thf(fact_60_le__infI2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B3: A,X: A,A3: A] :
          ( ( ord_less_eq @ A @ B3 @ X )
         => ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ X ) ) ) ).

% le_infI2
thf(fact_61_le__infI1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,X: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ X )
         => ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ X ) ) ) ).

% le_infI1
thf(fact_62_inf__mono,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,C: A,B3: A,D: A] :
          ( ( ord_less_eq @ A @ A3 @ C )
         => ( ( ord_less_eq @ A @ B3 @ D )
           => ( ord_less_eq @ A @ ( inf_inf @ A @ A3 @ B3 ) @ ( inf_inf @ A @ C @ D ) ) ) ) ) ).

% inf_mono
thf(fact_63_le__infI,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,A3: A,B3: A] :
          ( ( ord_less_eq @ A @ X @ A3 )
         => ( ( ord_less_eq @ A @ X @ B3 )
           => ( ord_less_eq @ A @ X @ ( inf_inf @ A @ A3 @ B3 ) ) ) ) ) ).

% le_infI
thf(fact_64_le__infE,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,A3: A,B3: A] :
          ( ( ord_less_eq @ A @ X @ ( inf_inf @ A @ A3 @ B3 ) )
         => ~ ( ( ord_less_eq @ A @ X @ A3 )
             => ~ ( ord_less_eq @ A @ X @ B3 ) ) ) ) ).

% le_infE
thf(fact_65_inf__le2,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ X @ Y ) @ Y ) ) ).

% inf_le2
thf(fact_66_inf__le1,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ X @ Y ) @ X ) ) ).

% inf_le1
thf(fact_67_inf__sup__ord_I1_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ X @ Y ) @ X ) ) ).

% inf_sup_ord(1)
thf(fact_68_inf__sup__ord_I2_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] : ( ord_less_eq @ A @ ( inf_inf @ A @ X @ Y ) @ Y ) ) ).

% inf_sup_ord(2)
thf(fact_69_not__Cons__self2,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( cons @ A @ X @ Xs )
     != Xs ) ).

% not_Cons_self2
thf(fact_70_inf__left__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ Y @ Z ) )
          = ( inf_inf @ A @ Y @ ( inf_inf @ A @ X @ Z ) ) ) ) ).

% inf_left_commute
thf(fact_71_inf_Oleft__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( inf_inf @ A @ B3 @ ( inf_inf @ A @ A3 @ C ) )
          = ( inf_inf @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) ) ) ) ).

% inf.left_commute
thf(fact_72_inf__commute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( inf_inf @ A )
        = ( ^ [X3: A,Y2: A] : ( inf_inf @ A @ Y2 @ X3 ) ) ) ) ).

% inf_commute
thf(fact_73_inf_Ocommute,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ( ( inf_inf @ A )
        = ( ^ [A4: A,B4: A] : ( inf_inf @ A @ B4 @ A4 ) ) ) ) ).

% inf.commute
thf(fact_74_inf__assoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X @ Y ) @ Z )
          = ( inf_inf @ A @ X @ ( inf_inf @ A @ Y @ Z ) ) ) ) ).

% inf_assoc
thf(fact_75_inf_Oassoc,axiom,
    ! [A: $tType] :
      ( ( semilattice_inf @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ A3 @ B3 ) @ C )
          = ( inf_inf @ A @ A3 @ ( inf_inf @ A @ B3 @ C ) ) ) ) ).

% inf.assoc
thf(fact_76_inf__fun__def,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( semilattice_inf @ B2 @ ( type2 @ B2 ) )
     => ( ( inf_inf @ ( A > B2 ) )
        = ( ^ [F: A > B2,G: A > B2,X3: A] : ( inf_inf @ B2 @ ( F @ X3 ) @ ( G @ X3 ) ) ) ) ) ).

% inf_fun_def
thf(fact_77_inf__sup__aci_I1_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ( ( inf_inf @ A )
        = ( ^ [X3: A,Y2: A] : ( inf_inf @ A @ Y2 @ X3 ) ) ) ) ).

% inf_sup_aci(1)
thf(fact_78_inf__sup__aci_I2_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ ( inf_inf @ A @ X @ Y ) @ Z )
          = ( inf_inf @ A @ X @ ( inf_inf @ A @ Y @ Z ) ) ) ) ).

% inf_sup_aci(2)
thf(fact_79_inf__sup__aci_I3_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ Y @ Z ) )
          = ( inf_inf @ A @ Y @ ( inf_inf @ A @ X @ Z ) ) ) ) ).

% inf_sup_aci(3)
thf(fact_80_inf__sup__aci_I4_J,axiom,
    ! [A: $tType] :
      ( ( lattice @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( inf_inf @ A @ X @ ( inf_inf @ A @ X @ Y ) )
          = ( inf_inf @ A @ X @ Y ) ) ) ).

% inf_sup_aci(4)
thf(fact_81_Int__left__commute,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ A2 @ ( inf_inf @ ( set @ A ) @ B @ C2 ) )
      = ( inf_inf @ ( set @ A ) @ B @ ( inf_inf @ ( set @ A ) @ A2 @ C2 ) ) ) ).

% Int_left_commute
thf(fact_82_Int__left__absorb,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ A2 @ ( inf_inf @ ( set @ A ) @ A2 @ B ) )
      = ( inf_inf @ ( set @ A ) @ A2 @ B ) ) ).

% Int_left_absorb
thf(fact_83_Int__commute,axiom,
    ! [A: $tType] :
      ( ( inf_inf @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] : ( inf_inf @ ( set @ A ) @ B5 @ A5 ) ) ) ).

% Int_commute
thf(fact_84_Int__absorb,axiom,
    ! [A: $tType,A2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ A2 @ A2 )
      = A2 ) ).

% Int_absorb
thf(fact_85_Int__assoc,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C2: set @ A] :
      ( ( inf_inf @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ B ) @ C2 )
      = ( inf_inf @ ( set @ A ) @ A2 @ ( inf_inf @ ( set @ A ) @ B @ C2 ) ) ) ).

% Int_assoc
thf(fact_86_IntD2,axiom,
    ! [A: $tType,C: A,A2: set @ A,B: set @ A] :
      ( ( member @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B ) )
     => ( member @ A @ C @ B ) ) ).

% IntD2
thf(fact_87_IntD1,axiom,
    ! [A: $tType,C: A,A2: set @ A,B: set @ A] :
      ( ( member @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B ) )
     => ( member @ A @ C @ A2 ) ) ).

% IntD1
thf(fact_88_IntE,axiom,
    ! [A: $tType,C: A,A2: set @ A,B: set @ A] :
      ( ( member @ A @ C @ ( inf_inf @ ( set @ A ) @ A2 @ B ) )
     => ~ ( ( member @ A @ C @ A2 )
         => ~ ( member @ A @ C @ B ) ) ) ).

% IntE
thf(fact_89_sorted__many,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Zs: list @ A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( linorder_sorted @ A @ ( cons @ A @ Y @ Zs ) )
           => ( linorder_sorted @ A @ ( cons @ A @ X @ ( cons @ A @ Y @ Zs ) ) ) ) ) ) ).

% sorted_many
thf(fact_90_sorted__Cons,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Xs: list @ A] :
          ( ( linorder_sorted @ A @ ( cons @ A @ X @ Xs ) )
          = ( ( linorder_sorted @ A @ Xs )
            & ! [X3: A] :
                ( ( member @ A @ X3 @ ( set2 @ A @ Xs ) )
               => ( ord_less_eq @ A @ X @ X3 ) ) ) ) ) ).

% sorted_Cons
thf(fact_91_sorted_OCons,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Xs: list @ A,X: A] :
          ( ! [X4: A] :
              ( ( member @ A @ X4 @ ( set2 @ A @ Xs ) )
             => ( ord_less_eq @ A @ X @ X4 ) )
         => ( ( linorder_sorted @ A @ Xs )
           => ( linorder_sorted @ A @ ( cons @ A @ X @ Xs ) ) ) ) ) ).

% sorted.Cons
thf(fact_92_list_Oset__cases,axiom,
    ! [A: $tType,E: A,A3: list @ A] :
      ( ( member @ A @ E @ ( set2 @ A @ A3 ) )
     => ( ! [Z22: list @ A] :
            ( A3
           != ( cons @ A @ E @ Z22 ) )
       => ~ ! [Z1: A,Z22: list @ A] :
              ( ( A3
                = ( cons @ A @ Z1 @ Z22 ) )
             => ~ ( member @ A @ E @ ( set2 @ A @ Z22 ) ) ) ) ) ).

% list.set_cases
thf(fact_93_set__ConsD,axiom,
    ! [A: $tType,Y: A,X: A,Xs: list @ A] :
      ( ( member @ A @ Y @ ( set2 @ A @ ( cons @ A @ X @ Xs ) ) )
     => ( ( Y = X )
        | ( member @ A @ Y @ ( set2 @ A @ Xs ) ) ) ) ).

% set_ConsD
thf(fact_94_list_Oset__intros_I1_J,axiom,
    ! [A: $tType,A1: A,A22: list @ A] : ( member @ A @ A1 @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ).

% list.set_intros(1)
thf(fact_95_list_Oset__intros_I2_J,axiom,
    ! [A: $tType,X: A,A22: list @ A,A1: A] :
      ( ( member @ A @ X @ ( set2 @ A @ A22 ) )
     => ( member @ A @ X @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ) ).

% list.set_intros(2)
thf(fact_96_distinct__length__2__or__more,axiom,
    ! [A: $tType,A3: A,B3: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ A3 @ ( cons @ A @ B3 @ Xs ) ) )
      = ( ( A3 != B3 )
        & ( distinct @ A @ ( cons @ A @ A3 @ Xs ) )
        & ( distinct @ A @ ( cons @ A @ B3 @ Xs ) ) ) ) ).

% distinct_length_2_or_more
thf(fact_97_distinct__union,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( distinct @ A @ ( union @ A @ Xs @ Ys ) )
      = ( distinct @ A @ Ys ) ) ).

% distinct_union
thf(fact_98_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_99_minf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z2: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z2 )
         => ~ ( ord_less_eq @ A @ T @ X5 ) ) ) ).

% minf(8)
thf(fact_100_minf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z2: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z2 )
         => ( ord_less_eq @ A @ X5 @ T ) ) ) ).

% minf(6)
thf(fact_101_pinf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z2: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z2 @ X5 )
         => ( ord_less_eq @ A @ T @ X5 ) ) ) ).

% pinf(8)
thf(fact_102_pinf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z2: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z2 @ X5 )
         => ~ ( ord_less_eq @ A @ X5 @ T ) ) ) ).

% pinf(6)
thf(fact_103_leD,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ~ ( ord_less @ A @ X @ Y ) ) ) ).

% leD
thf(fact_104_leI,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less @ A @ X @ Y )
         => ( ord_less_eq @ A @ Y @ X ) ) ) ).

% leI
thf(fact_105_le__less,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [X3: A,Y2: A] :
              ( ( ord_less @ A @ X3 @ Y2 )
              | ( X3 = Y2 ) ) ) ) ) ).

% le_less
thf(fact_106_Int__subset__iff,axiom,
    ! [A: $tType,C2: set @ A,A2: set @ A,B: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ C2 @ ( inf_inf @ ( set @ A ) @ A2 @ B ) )
      = ( ( ord_less_eq @ ( set @ A ) @ C2 @ A2 )
        & ( ord_less_eq @ ( set @ A ) @ C2 @ B ) ) ) ).

% Int_subset_iff
thf(fact_107_subset__code_I1_J,axiom,
    ! [A: $tType,Xs: list @ A,B: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ B )
      = ( ! [X3: A] :
            ( ( member @ A @ X3 @ ( set2 @ A @ Xs ) )
           => ( member @ A @ X3 @ B ) ) ) ) ).

% subset_code(1)
thf(fact_108_Int__mono,axiom,
    ! [A: $tType,A2: set @ A,C2: set @ A,B: set @ A,D2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ C2 )
     => ( ( ord_less_eq @ ( set @ A ) @ B @ D2 )
       => ( ord_less_eq @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ B ) @ ( inf_inf @ ( set @ A ) @ C2 @ D2 ) ) ) ) ).

% Int_mono
thf(fact_109_Int__lower1,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] : ( ord_less_eq @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ B ) @ A2 ) ).

% Int_lower1
thf(fact_110_Int__lower2,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] : ( ord_less_eq @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ B ) @ B ) ).

% Int_lower2
thf(fact_111_Int__absorb1,axiom,
    ! [A: $tType,B: set @ A,A2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ B @ A2 )
     => ( ( inf_inf @ ( set @ A ) @ A2 @ B )
        = B ) ) ).

% Int_absorb1
thf(fact_112_Int__absorb2,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( inf_inf @ ( set @ A ) @ A2 @ B )
        = A2 ) ) ).

% Int_absorb2
thf(fact_113_Int__greatest,axiom,
    ! [A: $tType,C2: set @ A,A2: set @ A,B: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ C2 @ A2 )
     => ( ( ord_less_eq @ ( set @ A ) @ C2 @ B )
       => ( ord_less_eq @ ( set @ A ) @ C2 @ ( inf_inf @ ( set @ A ) @ A2 @ B ) ) ) ) ).

% Int_greatest
thf(fact_114_Int__Collect__mono,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ! [X4: A] :
            ( ( member @ A @ X4 @ A2 )
           => ( ( P @ X4 )
             => ( Q @ X4 ) ) )
       => ( ord_less_eq @ ( set @ A ) @ ( inf_inf @ ( set @ A ) @ A2 @ ( collect @ A @ P ) ) @ ( inf_inf @ ( set @ A ) @ B @ ( collect @ A @ Q ) ) ) ) ) ).

% Int_Collect_mono
thf(fact_115_set__subset__Cons,axiom,
    ! [A: $tType,Xs: list @ A,X: A] : ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ ( set2 @ A @ ( cons @ A @ X @ Xs ) ) ) ).

% set_subset_Cons
thf(fact_116_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( ord_less_eq @ A @ A3 @ B3 )
           => ( A3 = B3 ) ) ) ) ).

% dual_order.antisym
thf(fact_117_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( ord_less_eq @ A @ C @ B3 )
           => ( ord_less_eq @ A @ C @ A3 ) ) ) ) ).

% dual_order.trans
thf(fact_118_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A3: A,B3: A] :
          ( ! [A6: A,B6: A] :
              ( ( ord_less_eq @ A @ A6 @ B6 )
             => ( P @ A6 @ B6 ) )
         => ( ! [A6: A,B6: A] :
                ( ( P @ B6 @ A6 )
               => ( P @ A6 @ B6 ) )
           => ( P @ A3 @ B3 ) ) ) ) ).

% linorder_wlog
thf(fact_119_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A] : ( ord_less_eq @ A @ A3 @ A3 ) ) ).

% dual_order.refl
thf(fact_120_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z )
           => ( ord_less_eq @ A @ X @ Z ) ) ) ) ).

% order_trans
thf(fact_121_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ A3 )
           => ( A3 = B3 ) ) ) ) ).

% order_class.order.antisym
thf(fact_122_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( B3 = C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_123_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( A3 = B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_124_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ( ( ord_less_eq @ A @ X @ Y )
            = ( X = Y ) ) ) ) ).

% antisym_conv
thf(fact_125_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ( ord_less_eq @ A @ X @ Y )
           => ~ ( ord_less_eq @ A @ Y @ Z ) )
         => ( ( ( ord_less_eq @ A @ Y @ X )
             => ~ ( ord_less_eq @ A @ X @ Z ) )
           => ( ( ( ord_less_eq @ A @ X @ Z )
               => ~ ( ord_less_eq @ A @ Z @ Y ) )
             => ( ( ( ord_less_eq @ A @ Z @ Y )
                 => ~ ( ord_less_eq @ A @ Y @ X ) )
               => ( ( ( ord_less_eq @ A @ Y @ Z )
                   => ~ ( ord_less_eq @ A @ Z @ X ) )
                 => ~ ( ( ord_less_eq @ A @ Z @ X )
                     => ~ ( ord_less_eq @ A @ X @ Y ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_126_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ord_less_eq @ A @ A3 @ C ) ) ) ) ).

% order.trans
thf(fact_127_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less_eq @ A @ X @ Y )
         => ( ord_less_eq @ A @ Y @ X ) ) ) ).

% le_cases
thf(fact_128_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( X = Y )
         => ( ord_less_eq @ A @ X @ Y ) ) ) ).

% eq_refl
thf(fact_129_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
          | ( ord_less_eq @ A @ Y @ X ) ) ) ).

% linear
thf(fact_130_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ X )
           => ( X = Y ) ) ) ) ).

% antisym
thf(fact_131_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y4: A,Z3: A] : ( Y4 = Z3 ) )
        = ( ^ [X3: A,Y2: A] :
              ( ( ord_less_eq @ A @ X3 @ Y2 )
              & ( ord_less_eq @ A @ Y2 @ X3 ) ) ) ) ) ).

% eq_iff
thf(fact_132_ord__le__eq__subst,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( ord @ B2 @ ( type2 @ B2 ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F2: A > B2,C: B2] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ( F2 @ B3 )
              = C )
           => ( ! [X4: A,Y3: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y3 )
                 => ( ord_less_eq @ B2 @ ( F2 @ X4 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less_eq @ B2 @ ( F2 @ A3 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_133_ord__eq__le__subst,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( ord @ B2 @ ( type2 @ B2 ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F2: B2 > A,B3: B2,C: B2] :
          ( ( A3
            = ( F2 @ B3 ) )
         => ( ( ord_less_eq @ B2 @ B3 @ C )
           => ( ! [X4: B2,Y3: B2] :
                  ( ( ord_less_eq @ B2 @ X4 @ Y3 )
                 => ( ord_less_eq @ A @ ( F2 @ X4 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less_eq @ A @ A3 @ ( F2 @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_134_order__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F2: A > C3,C: C3] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ C3 @ ( F2 @ B3 ) @ C )
           => ( ! [X4: A,Y3: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y3 )
                 => ( ord_less_eq @ C3 @ ( F2 @ X4 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less_eq @ C3 @ ( F2 @ A3 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_135_order__subst1,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( order @ B2 @ ( type2 @ B2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F2: B2 > A,B3: B2,C: B2] :
          ( ( ord_less_eq @ A @ A3 @ ( F2 @ B3 ) )
         => ( ( ord_less_eq @ B2 @ B3 @ C )
           => ( ! [X4: B2,Y3: B2] :
                  ( ( ord_less_eq @ B2 @ X4 @ Y3 )
                 => ( ord_less_eq @ A @ ( F2 @ X4 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less_eq @ A @ A3 @ ( F2 @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_136_le__fun__def,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 @ ( type2 @ B2 ) )
     => ( ( ord_less_eq @ ( A > B2 ) )
        = ( ^ [F: A > B2,G: A > B2] :
            ! [X3: A] : ( ord_less_eq @ B2 @ ( F @ X3 ) @ ( G @ X3 ) ) ) ) ) ).

% le_fun_def
thf(fact_137_le__funI,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 @ ( type2 @ B2 ) )
     => ! [F2: A > B2,G2: A > B2] :
          ( ! [X4: A] : ( ord_less_eq @ B2 @ ( F2 @ X4 ) @ ( G2 @ X4 ) )
         => ( ord_less_eq @ ( A > B2 ) @ F2 @ G2 ) ) ) ).

% le_funI
thf(fact_138_le__funE,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 @ ( type2 @ B2 ) )
     => ! [F2: A > B2,G2: A > B2,X: A] :
          ( ( ord_less_eq @ ( A > B2 ) @ F2 @ G2 )
         => ( ord_less_eq @ B2 @ ( F2 @ X ) @ ( G2 @ X ) ) ) ) ).

% le_funE
thf(fact_139_le__funD,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 @ ( type2 @ B2 ) )
     => ! [F2: A > B2,G2: A > B2,X: A] :
          ( ( ord_less_eq @ ( A > B2 ) @ F2 @ G2 )
         => ( ord_less_eq @ B2 @ ( F2 @ X ) @ ( G2 @ X ) ) ) ) ).

% le_funD
thf(fact_140_dual__order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A] :
          ( ( ord_less @ A @ B3 @ A3 )
         => ( A3 != B3 ) ) ) ).

% dual_order.strict_implies_not_eq
thf(fact_141_order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( A3 != B3 ) ) ) ).

% order.strict_implies_not_eq
thf(fact_142_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ~ ( ord_less @ A @ X @ Y ) )
          = ( ( ord_less @ A @ Y @ X )
            | ( X = Y ) ) ) ) ).

% not_less_iff_gr_or_eq
thf(fact_143_dual__order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less @ A @ B3 @ A3 )
         => ( ( ord_less @ A @ C @ B3 )
           => ( ord_less @ A @ C @ A3 ) ) ) ) ).

% dual_order.strict_trans
thf(fact_144_less__imp__not__less,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ~ ( ord_less @ A @ Y @ X ) ) ) ).

% less_imp_not_less
thf(fact_145_order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( ord_less @ A @ B3 @ C )
           => ( ord_less @ A @ A3 @ C ) ) ) ) ).

% order.strict_trans
thf(fact_146_dual__order_Oirrefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A] :
          ~ ( ord_less @ A @ A3 @ A3 ) ) ).

% dual_order.irrefl
thf(fact_147_linorder__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less @ A @ X @ Y )
         => ( ( X != Y )
           => ( ord_less @ A @ Y @ X ) ) ) ) ).

% linorder_cases
thf(fact_148_less__imp__triv,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,P: $o] :
          ( ( ord_less @ A @ X @ Y )
         => ( ( ord_less @ A @ Y @ X )
           => P ) ) ) ).

% less_imp_triv
thf(fact_149_less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( Y != X ) ) ) ).

% less_imp_not_eq2
thf(fact_150_antisym__conv3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ~ ( ord_less @ A @ Y @ X )
         => ( ( ~ ( ord_less @ A @ X @ Y ) )
            = ( X = Y ) ) ) ) ).

% antisym_conv3
thf(fact_151_less__induct,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,A3: A] :
          ( ! [X4: A] :
              ( ! [Y5: A] :
                  ( ( ord_less @ A @ Y5 @ X4 )
                 => ( P @ Y5 ) )
             => ( P @ X4 ) )
         => ( P @ A3 ) ) ) ).

% less_induct
thf(fact_152_less__not__sym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ~ ( ord_less @ A @ Y @ X ) ) ) ).

% less_not_sym
thf(fact_153_less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( X != Y ) ) ) ).

% less_imp_not_eq
thf(fact_154_dual__order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A] :
          ( ( ord_less @ A @ B3 @ A3 )
         => ~ ( ord_less @ A @ A3 @ B3 ) ) ) ).

% dual_order.asym
thf(fact_155_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( B3 = C )
           => ( ord_less @ A @ A3 @ C ) ) ) ) ).

% ord_less_eq_trans
thf(fact_156_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( A3 = B3 )
         => ( ( ord_less @ A @ B3 @ C )
           => ( ord_less @ A @ A3 @ C ) ) ) ) ).

% ord_eq_less_trans
thf(fact_157_less__irrefl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ~ ( ord_less @ A @ X @ X ) ) ).

% less_irrefl
thf(fact_158_less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
          | ( X = Y )
          | ( ord_less @ A @ Y @ X ) ) ) ).

% less_linear
thf(fact_159_less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( ( ord_less @ A @ Y @ Z )
           => ( ord_less @ A @ X @ Z ) ) ) ) ).

% less_trans
thf(fact_160_less__asym_H,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ~ ( ord_less @ A @ B3 @ A3 ) ) ) ).

% less_asym'
thf(fact_161_less__asym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ~ ( ord_less @ A @ Y @ X ) ) ) ).

% less_asym
thf(fact_162_less__imp__neq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( X != Y ) ) ) ).

% less_imp_neq
thf(fact_163_dense,axiom,
    ! [A: $tType] :
      ( ( dense_order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ? [Z2: A] :
              ( ( ord_less @ A @ X @ Z2 )
              & ( ord_less @ A @ Z2 @ Y ) ) ) ) ).

% dense
thf(fact_164_order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ~ ( ord_less @ A @ B3 @ A3 ) ) ) ).

% order.asym
thf(fact_165_neq__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( X != Y )
          = ( ( ord_less @ A @ X @ Y )
            | ( ord_less @ A @ Y @ X ) ) ) ) ).

% neq_iff
thf(fact_166_neqE,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( X != Y )
         => ( ~ ( ord_less @ A @ X @ Y )
           => ( ord_less @ A @ Y @ X ) ) ) ) ).

% neqE
thf(fact_167_gt__ex,axiom,
    ! [A: $tType] :
      ( ( no_top @ A @ ( type2 @ A ) )
     => ! [X: A] :
        ? [X12: A] : ( ord_less @ A @ X @ X12 ) ) ).

% gt_ex
thf(fact_168_lt__ex,axiom,
    ! [A: $tType] :
      ( ( no_bot @ A @ ( type2 @ A ) )
     => ! [X: A] :
        ? [Y3: A] : ( ord_less @ A @ Y3 @ X ) ) ).

% lt_ex
thf(fact_169_order__less__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F2: A > C3,C: C3] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( ord_less @ C3 @ ( F2 @ B3 ) @ C )
           => ( ! [X4: A,Y3: A] :
                  ( ( ord_less @ A @ X4 @ Y3 )
                 => ( ord_less @ C3 @ ( F2 @ X4 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less @ C3 @ ( F2 @ A3 ) @ C ) ) ) ) ) ).

% order_less_subst2
thf(fact_170_order__less__subst1,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( order @ B2 @ ( type2 @ B2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F2: B2 > A,B3: B2,C: B2] :
          ( ( ord_less @ A @ A3 @ ( F2 @ B3 ) )
         => ( ( ord_less @ B2 @ B3 @ C )
           => ( ! [X4: B2,Y3: B2] :
                  ( ( ord_less @ B2 @ X4 @ Y3 )
                 => ( ord_less @ A @ ( F2 @ X4 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less @ A @ A3 @ ( F2 @ C ) ) ) ) ) ) ).

% order_less_subst1
thf(fact_171_ord__less__eq__subst,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( ord @ B2 @ ( type2 @ B2 ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F2: A > B2,C: B2] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( ( F2 @ B3 )
              = C )
           => ( ! [X4: A,Y3: A] :
                  ( ( ord_less @ A @ X4 @ Y3 )
                 => ( ord_less @ B2 @ ( F2 @ X4 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less @ B2 @ ( F2 @ A3 ) @ C ) ) ) ) ) ).

% ord_less_eq_subst
thf(fact_172_ord__eq__less__subst,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( ord @ B2 @ ( type2 @ B2 ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F2: B2 > A,B3: B2,C: B2] :
          ( ( A3
            = ( F2 @ B3 ) )
         => ( ( ord_less @ B2 @ B3 @ C )
           => ( ! [X4: B2,Y3: B2] :
                  ( ( ord_less @ B2 @ X4 @ Y3 )
                 => ( ord_less @ A @ ( F2 @ X4 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less @ A @ A3 @ ( F2 @ C ) ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_173_pinf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P2: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z4: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ Z4 @ X4 )
             => ( ( P @ X4 )
                = ( P2 @ X4 ) ) )
         => ( ? [Z4: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ Z4 @ X4 )
               => ( ( Q @ X4 )
                  = ( Q2 @ X4 ) ) )
           => ? [Z2: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ Z2 @ X5 )
               => ( ( ( P @ X5 )
                    & ( Q @ X5 ) )
                  = ( ( P2 @ X5 )
                    & ( Q2 @ X5 ) ) ) ) ) ) ) ).

% pinf(1)
thf(fact_174_pinf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P2: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z4: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ Z4 @ X4 )
             => ( ( P @ X4 )
                = ( P2 @ X4 ) ) )
         => ( ? [Z4: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ Z4 @ X4 )
               => ( ( Q @ X4 )
                  = ( Q2 @ X4 ) ) )
           => ? [Z2: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ Z2 @ X5 )
               => ( ( ( P @ X5 )
                    | ( Q @ X5 ) )
                  = ( ( P2 @ X5 )
                    | ( Q2 @ X5 ) ) ) ) ) ) ) ).

% pinf(2)
thf(fact_175_pinf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z2: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z2 @ X5 )
         => ( X5 != T ) ) ) ).

% pinf(3)
thf(fact_176_pinf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z2: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z2 @ X5 )
         => ( X5 != T ) ) ) ).

% pinf(4)
thf(fact_177_pinf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z2: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z2 @ X5 )
         => ~ ( ord_less @ A @ X5 @ T ) ) ) ).

% pinf(5)
thf(fact_178_pinf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z2: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z2 @ X5 )
         => ( ord_less @ A @ T @ X5 ) ) ) ).

% pinf(7)
thf(fact_179_pinf_I11_J,axiom,
    ! [C3: $tType,D3: $tType] :
      ( ( ord @ C3 @ ( type2 @ C3 ) )
     => ! [F3: D3] :
        ? [Z2: C3] :
        ! [X5: C3] :
          ( ( ord_less @ C3 @ Z2 @ X5 )
         => ( F3 = F3 ) ) ) ).

% pinf(11)
thf(fact_180_minf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P2: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z4: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ X4 @ Z4 )
             => ( ( P @ X4 )
                = ( P2 @ X4 ) ) )
         => ( ? [Z4: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ X4 @ Z4 )
               => ( ( Q @ X4 )
                  = ( Q2 @ X4 ) ) )
           => ? [Z2: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ X5 @ Z2 )
               => ( ( ( P @ X5 )
                    & ( Q @ X5 ) )
                  = ( ( P2 @ X5 )
                    & ( Q2 @ X5 ) ) ) ) ) ) ) ).

% minf(1)
thf(fact_181_minf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P2: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z4: A] :
            ! [X4: A] :
              ( ( ord_less @ A @ X4 @ Z4 )
             => ( ( P @ X4 )
                = ( P2 @ X4 ) ) )
         => ( ? [Z4: A] :
              ! [X4: A] :
                ( ( ord_less @ A @ X4 @ Z4 )
               => ( ( Q @ X4 )
                  = ( Q2 @ X4 ) ) )
           => ? [Z2: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ X5 @ Z2 )
               => ( ( ( P @ X5 )
                    | ( Q @ X5 ) )
                  = ( ( P2 @ X5 )
                    | ( Q2 @ X5 ) ) ) ) ) ) ) ).

% minf(2)
thf(fact_182_minf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z2: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z2 )
         => ( X5 != T ) ) ) ).

% minf(3)
thf(fact_183_minf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z2: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z2 )
         => ( X5 != T ) ) ) ).

% minf(4)
thf(fact_184_minf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z2: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z2 )
         => ( ord_less @ A @ X5 @ T ) ) ) ).

% minf(5)
thf(fact_185_minf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z2: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z2 )
         => ~ ( ord_less @ A @ T @ X5 ) ) ) ).

% minf(7)
thf(fact_186_minf_I11_J,axiom,
    ! [C3: $tType,D3: $tType] :
      ( ( ord @ C3 @ ( type2 @ C3 ) )
     => ! [F3: D3] :
        ? [Z2: C3] :
        ! [X5: C3] :
          ( ( ord_less @ C3 @ X5 @ Z2 )
         => ( F3 = F3 ) ) ) ).

% minf(11)
thf(fact_187_order_Onot__eq__order__implies__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( A3 != B3 )
         => ( ( ord_less_eq @ A @ A3 @ B3 )
           => ( ord_less @ A @ A3 @ B3 ) ) ) ) ).

% order.not_eq_order_implies_strict
thf(fact_188_dual__order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A] :
          ( ( ord_less @ A @ B3 @ A3 )
         => ( ord_less_eq @ A @ B3 @ A3 ) ) ) ).

% dual_order.strict_implies_order
thf(fact_189_dual__order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [B4: A,A4: A] :
              ( ( ord_less_eq @ A @ B4 @ A4 )
              & ( A4 != B4 ) ) ) ) ) ).

% dual_order.strict_iff_order
thf(fact_190_dual__order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [B4: A,A4: A] :
              ( ( ord_less @ A @ B4 @ A4 )
              | ( A4 = B4 ) ) ) ) ) ).

% dual_order.order_iff_strict
thf(fact_191_order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ord_less_eq @ A @ A3 @ B3 ) ) ) ).

% order.strict_implies_order
thf(fact_192_dense__le__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( ! [W: A] :
                ( ( ord_less @ A @ X @ W )
               => ( ( ord_less @ A @ W @ Y )
                 => ( ord_less_eq @ A @ W @ Z ) ) )
           => ( ord_less_eq @ A @ Y @ Z ) ) ) ) ).

% dense_le_bounded
thf(fact_193_dense__ge__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Z: A,X: A,Y: A] :
          ( ( ord_less @ A @ Z @ X )
         => ( ! [W: A] :
                ( ( ord_less @ A @ Z @ W )
               => ( ( ord_less @ A @ W @ X )
                 => ( ord_less_eq @ A @ Y @ W ) ) )
           => ( ord_less_eq @ A @ Y @ Z ) ) ) ) ).

% dense_ge_bounded
thf(fact_194_dual__order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less @ A @ B3 @ A3 )
         => ( ( ord_less_eq @ A @ C @ B3 )
           => ( ord_less @ A @ C @ A3 ) ) ) ) ).

% dual_order.strict_trans2
thf(fact_195_dual__order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B3: A,A3: A,C: A] :
          ( ( ord_less_eq @ A @ B3 @ A3 )
         => ( ( ord_less @ A @ C @ B3 )
           => ( ord_less @ A @ C @ A3 ) ) ) ) ).

% dual_order.strict_trans1
thf(fact_196_order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [A4: A,B4: A] :
              ( ( ord_less_eq @ A @ A4 @ B4 )
              & ( A4 != B4 ) ) ) ) ) ).

% order.strict_iff_order
thf(fact_197_order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A4: A,B4: A] :
              ( ( ord_less @ A @ A4 @ B4 )
              | ( A4 = B4 ) ) ) ) ) ).

% order.order_iff_strict
thf(fact_198_order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ A @ B3 @ C )
           => ( ord_less @ A @ A3 @ C ) ) ) ) ).

% order.strict_trans2
thf(fact_199_order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,C: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less @ A @ B3 @ C )
           => ( ord_less @ A @ A3 @ C ) ) ) ) ).

% order.strict_trans1
thf(fact_200_not__le__imp__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ~ ( ord_less_eq @ A @ Y @ X )
         => ( ord_less @ A @ X @ Y ) ) ) ).

% not_le_imp_less
thf(fact_201_less__le__not__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [X3: A,Y2: A] :
              ( ( ord_less_eq @ A @ X3 @ Y2 )
              & ~ ( ord_less_eq @ A @ Y2 @ X3 ) ) ) ) ) ).

% less_le_not_le
thf(fact_202_le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less @ A @ X @ Y )
            | ( X = Y ) ) ) ) ).

% le_imp_less_or_eq
thf(fact_203_le__less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
          | ( ord_less @ A @ Y @ X ) ) ) ).

% le_less_linear
thf(fact_204_dense__le,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Y: A,Z: A] :
          ( ! [X4: A] :
              ( ( ord_less @ A @ X4 @ Y )
             => ( ord_less_eq @ A @ X4 @ Z ) )
         => ( ord_less_eq @ A @ Y @ Z ) ) ) ).

% dense_le
thf(fact_205_dense__ge,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Z: A,Y: A] :
          ( ! [X4: A] :
              ( ( ord_less @ A @ Z @ X4 )
             => ( ord_less_eq @ A @ Y @ X4 ) )
         => ( ord_less_eq @ A @ Y @ Z ) ) ) ).

% dense_ge
thf(fact_206_less__le__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z )
           => ( ord_less @ A @ X @ Z ) ) ) ) ).

% less_le_trans
thf(fact_207_le__less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less @ A @ Y @ Z )
           => ( ord_less @ A @ X @ Z ) ) ) ) ).

% le_less_trans
thf(fact_208_antisym__conv2,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ~ ( ord_less @ A @ X @ Y ) )
            = ( X = Y ) ) ) ) ).

% antisym_conv2
thf(fact_209_antisym__conv1,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ X @ Y )
            = ( X = Y ) ) ) ) ).

% antisym_conv1
thf(fact_210_less__imp__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less @ A @ X @ Y )
         => ( ord_less_eq @ A @ X @ Y ) ) ) ).

% less_imp_le
thf(fact_211_le__neq__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( A3 != B3 )
           => ( ord_less @ A @ A3 @ B3 ) ) ) ) ).

% le_neq_trans
thf(fact_212_not__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ~ ( ord_less @ A @ X @ Y ) )
          = ( ord_less_eq @ A @ Y @ X ) ) ) ).

% not_less
thf(fact_213_not__le,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ~ ( ord_less_eq @ A @ X @ Y ) )
          = ( ord_less @ A @ Y @ X ) ) ) ).

% not_le
thf(fact_214_order__less__le__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F2: A > C3,C: C3] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( ord_less_eq @ C3 @ ( F2 @ B3 ) @ C )
           => ( ! [X4: A,Y3: A] :
                  ( ( ord_less @ A @ X4 @ Y3 )
                 => ( ord_less @ C3 @ ( F2 @ X4 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less @ C3 @ ( F2 @ A3 ) @ C ) ) ) ) ) ).

% order_less_le_subst2
thf(fact_215_order__less__le__subst1,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( order @ B2 @ ( type2 @ B2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F2: B2 > A,B3: B2,C: B2] :
          ( ( ord_less @ A @ A3 @ ( F2 @ B3 ) )
         => ( ( ord_less_eq @ B2 @ B3 @ C )
           => ( ! [X4: B2,Y3: B2] :
                  ( ( ord_less_eq @ B2 @ X4 @ Y3 )
                 => ( ord_less_eq @ A @ ( F2 @ X4 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less @ A @ A3 @ ( F2 @ C ) ) ) ) ) ) ).

% order_less_le_subst1
thf(fact_216_order__le__less__subst2,axiom,
    ! [A: $tType,C3: $tType] :
      ( ( ( order @ C3 @ ( type2 @ C3 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,B3: A,F2: A > C3,C: C3] :
          ( ( ord_less_eq @ A @ A3 @ B3 )
         => ( ( ord_less @ C3 @ ( F2 @ B3 ) @ C )
           => ( ! [X4: A,Y3: A] :
                  ( ( ord_less_eq @ A @ X4 @ Y3 )
                 => ( ord_less_eq @ C3 @ ( F2 @ X4 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less @ C3 @ ( F2 @ A3 ) @ C ) ) ) ) ) ).

% order_le_less_subst2
thf(fact_217_order__le__less__subst1,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ( order @ B2 @ ( type2 @ B2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A3: A,F2: B2 > A,B3: B2,C: B2] :
          ( ( ord_less_eq @ A @ A3 @ ( F2 @ B3 ) )
         => ( ( ord_less @ B2 @ B3 @ C )
           => ( ! [X4: B2,Y3: B2] :
                  ( ( ord_less @ B2 @ X4 @ Y3 )
                 => ( ord_less @ A @ ( F2 @ X4 ) @ ( F2 @ Y3 ) ) )
             => ( ord_less @ A @ A3 @ ( F2 @ C ) ) ) ) ) ) ).

% order_le_less_subst1
thf(fact_218_less__le,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [X3: A,Y2: A] :
              ( ( ord_less_eq @ A @ X3 @ Y2 )
              & ( X3 != Y2 ) ) ) ) ) ).

% less_le
thf(fact_219_complete__interval,axiom,
    ! [A: $tType] :
      ( ( condit1037483654norder @ A @ ( type2 @ A ) )
     => ! [A3: A,B3: A,P: A > $o] :
          ( ( ord_less @ A @ A3 @ B3 )
         => ( ( P @ A3 )
           => ( ~ ( P @ B3 )
             => ? [C4: A] :
                  ( ( ord_less_eq @ A @ A3 @ C4 )
                  & ( ord_less_eq @ A @ C4 @ B3 )
                  & ! [X5: A] :
                      ( ( ( ord_less_eq @ A @ A3 @ X5 )
                        & ( ord_less @ A @ X5 @ C4 ) )
                     => ( P @ X5 ) )
                  & ! [D4: A] :
                      ( ! [X4: A] :
                          ( ( ( ord_less_eq @ A @ A3 @ X4 )
                            & ( ord_less @ A @ X4 @ D4 ) )
                         => ( P @ X4 ) )
                     => ( ord_less_eq @ A @ D4 @ C4 ) ) ) ) ) ) ) ).

% complete_interval
thf(fact_220_not__in__set__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ~ ( member @ A @ X @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X @ Xs )
        = ( cons @ A @ X @ Xs ) ) ) ).

% not_in_set_insert
thf(fact_221_sorted_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [A3: list @ A] :
          ( ( linorder_sorted @ A @ A3 )
         => ( ( A3
             != ( nil @ A ) )
           => ~ ! [Xs2: list @ A,X4: A] :
                  ( ( A3
                    = ( cons @ A @ X4 @ Xs2 ) )
                 => ( ! [Xa: A] :
                        ( ( member @ A @ Xa @ ( set2 @ A @ Xs2 ) )
                       => ( ord_less_eq @ A @ X4 @ Xa ) )
                   => ~ ( linorder_sorted @ A @ Xs2 ) ) ) ) ) ) ).

% sorted.cases
thf(fact_222_sorted_Osimps,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ( linorder_sorted @ A )
        = ( ^ [A4: list @ A] :
              ( ( A4
                = ( nil @ A ) )
              | ? [Xs3: list @ A,X3: A] :
                  ( ( A4
                    = ( cons @ A @ X3 @ Xs3 ) )
                  & ! [Y2: A] :
                      ( ( member @ A @ Y2 @ ( set2 @ A @ Xs3 ) )
                     => ( ord_less_eq @ A @ X3 @ Y2 ) )
                  & ( linorder_sorted @ A @ Xs3 ) ) ) ) ) ) ).

% sorted.simps
thf(fact_223_sorted_Oinducts,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: list @ A,P: ( list @ A ) > $o] :
          ( ( linorder_sorted @ A @ X )
         => ( ( P @ ( nil @ A ) )
           => ( ! [Xs2: list @ A,X4: A] :
                  ( ! [Xa: A] :
                      ( ( member @ A @ Xa @ ( set2 @ A @ Xs2 ) )
                     => ( ord_less_eq @ A @ X4 @ Xa ) )
                 => ( ( linorder_sorted @ A @ Xs2 )
                   => ( ( P @ Xs2 )
                     => ( P @ ( cons @ A @ X4 @ Xs2 ) ) ) ) )
             => ( P @ X ) ) ) ) ) ).

% sorted.inducts
thf(fact_224_subsetI,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ! [X4: A] :
          ( ( member @ A @ X4 @ A2 )
         => ( member @ A @ X4 @ B ) )
     => ( ord_less_eq @ ( set @ A ) @ A2 @ B ) ) ).

% subsetI
thf(fact_225_psubsetI,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( A2 != B )
       => ( ord_less @ ( set @ A ) @ A2 @ B ) ) ) ).

% psubsetI
thf(fact_226_subset__antisym,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( ord_less_eq @ ( set @ A ) @ B @ A2 )
       => ( A2 = B ) ) ) ).

% subset_antisym
thf(fact_227_in__set__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member @ A @ X @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X @ Xs )
        = Xs ) ) ).

% in_set_insert
thf(fact_228_distinct__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( distinct @ A @ ( insert @ A @ X @ Xs ) )
      = ( distinct @ A @ Xs ) ) ).

% distinct_insert
thf(fact_229_sorted__single,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( linorder_sorted @ A @ ( cons @ A @ X @ ( nil @ A ) ) ) ) ).

% sorted_single
thf(fact_230_insert__Nil,axiom,
    ! [A: $tType,X: A] :
      ( ( insert @ A @ X @ ( nil @ A ) )
      = ( cons @ A @ X @ ( nil @ A ) ) ) ).

% insert_Nil
thf(fact_231_set__mp,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( member @ A @ X @ A2 )
       => ( member @ A @ X @ B ) ) ) ).

% set_mp
thf(fact_232_in__mono,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( member @ A @ X @ A2 )
       => ( member @ A @ X @ B ) ) ) ).

% in_mono
thf(fact_233_subsetD,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( member @ A @ C @ A2 )
       => ( member @ A @ C @ B ) ) ) ).

% subsetD
thf(fact_234_psubsetE,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A2 @ B )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
         => ( ord_less_eq @ ( set @ A ) @ B @ A2 ) ) ) ).

% psubsetE
thf(fact_235_subsetCE,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( member @ A @ C @ A2 )
       => ( member @ A @ C @ B ) ) ) ).

% subsetCE
thf(fact_236_equalityE,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( A2 = B )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
         => ~ ( ord_less_eq @ ( set @ A ) @ B @ A2 ) ) ) ).

% equalityE
thf(fact_237_subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
          ! [X3: A] :
            ( ( member @ A @ X3 @ A5 )
           => ( member @ A @ X3 @ B5 ) ) ) ) ).

% subset_eq
thf(fact_238_equalityD1,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( A2 = B )
     => ( ord_less_eq @ ( set @ A ) @ A2 @ B ) ) ).

% equalityD1
thf(fact_239_equalityD2,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( A2 = B )
     => ( ord_less_eq @ ( set @ A ) @ B @ A2 ) ) ).

% equalityD2
thf(fact_240_psubset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A5 @ B5 )
            & ( A5 != B5 ) ) ) ) ).

% psubset_eq
thf(fact_241_set__rev__mp,axiom,
    ! [A: $tType,X: A,A2: set @ A,B: set @ A] :
      ( ( member @ A @ X @ A2 )
     => ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
       => ( member @ A @ X @ B ) ) ) ).

% set_rev_mp
thf(fact_242_subset__iff,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
          ! [T2: A] :
            ( ( member @ A @ T2 @ A5 )
           => ( member @ A @ T2 @ B5 ) ) ) ) ).

% subset_iff
thf(fact_243_rev__subsetD,axiom,
    ! [A: $tType,C: A,A2: set @ A,B: set @ A] :
      ( ( member @ A @ C @ A2 )
     => ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
       => ( member @ A @ C @ B ) ) ) ).

% rev_subsetD
thf(fact_244_subset__refl,axiom,
    ! [A: $tType,A2: set @ A] : ( ord_less_eq @ ( set @ A ) @ A2 @ A2 ) ).

% subset_refl
thf(fact_245_Collect__mono,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X4: A] :
          ( ( P @ X4 )
         => ( Q @ X4 ) )
     => ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) ) ) ).

% Collect_mono
thf(fact_246_subset__trans,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( ord_less_eq @ ( set @ A ) @ B @ C2 )
       => ( ord_less_eq @ ( set @ A ) @ A2 @ C2 ) ) ) ).

% subset_trans
thf(fact_247_set__eq__subset,axiom,
    ! [A: $tType] :
      ( ( ^ [Y4: set @ A,Z3: set @ A] : ( Y4 = Z3 ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A5 @ B5 )
            & ( ord_less_eq @ ( set @ A ) @ B5 @ A5 ) ) ) ) ).

% set_eq_subset
thf(fact_248_contra__subsetD,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ~ ( member @ A @ C @ B )
       => ~ ( member @ A @ C @ A2 ) ) ) ).

% contra_subsetD
thf(fact_249_Collect__mono__iff,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) )
      = ( ! [X3: A] :
            ( ( P @ X3 )
           => ( Q @ X3 ) ) ) ) ).

% Collect_mono_iff
thf(fact_250_less__fun__def,axiom,
    ! [B2: $tType,A: $tType] :
      ( ( ord @ B2 @ ( type2 @ B2 ) )
     => ( ( ord_less @ ( A > B2 ) )
        = ( ^ [F: A > B2,G: A > B2] :
              ( ( ord_less_eq @ ( A > B2 ) @ F @ G )
              & ~ ( ord_less_eq @ ( A > B2 ) @ G @ F ) ) ) ) ) ).

% less_fun_def
thf(fact_251_psubset__imp__subset,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A2 @ B )
     => ( ord_less_eq @ ( set @ A ) @ A2 @ B ) ) ).

% psubset_imp_subset
thf(fact_252_psubset__subset__trans,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C2: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A2 @ B )
     => ( ( ord_less_eq @ ( set @ A ) @ B @ C2 )
       => ( ord_less @ ( set @ A ) @ A2 @ C2 ) ) ) ).

% psubset_subset_trans
thf(fact_253_subset__not__subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A5 @ B5 )
            & ~ ( ord_less_eq @ ( set @ A ) @ B5 @ A5 ) ) ) ) ).

% subset_not_subset_eq
thf(fact_254_subset__psubset__trans,axiom,
    ! [A: $tType,A2: set @ A,B: set @ A,C2: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A2 @ B )
     => ( ( ord_less @ ( set @ A ) @ B @ C2 )
       => ( ord_less @ ( set @ A ) @ A2 @ C2 ) ) ) ).

% subset_psubset_trans
thf(fact_255_subset__iff__psubset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A5: set @ A,B5: set @ A] :
            ( ( ord_less @ ( set @ A ) @ A5 @ B5 )
            | ( A5 = B5 ) ) ) ) ).

% subset_iff_psubset_eq

%----Subclasses (4)
thf(subcl_Orderings_Olinorder___HOL_Otype,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( type @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oord,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ord @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( order @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Opreorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( preorder @ A @ ( type2 @ A ) ) ) ).

%----Type constructors (16)
thf(tcon_fun___Lattices_Osemilattice__inf,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( semilattice_inf @ A8 @ ( type2 @ A8 ) )
     => ( semilattice_inf @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( preorder @ A8 @ ( type2 @ A8 ) )
     => ( preorder @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Lattices_Olattice,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( lattice @ A8 @ ( type2 @ A8 ) )
     => ( lattice @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( order @ A8 @ ( type2 @ A8 ) )
     => ( order @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( ord @ A8 @ ( type2 @ A8 ) )
     => ( ord @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_Set_Oset___Lattices_Osemilattice__inf_1,axiom,
    ! [A7: $tType] : ( semilattice_inf @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_2,axiom,
    ! [A7: $tType] : ( preorder @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Lattices_Olattice_3,axiom,
    ! [A7: $tType] : ( lattice @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_4,axiom,
    ! [A7: $tType] : ( order @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_5,axiom,
    ! [A7: $tType] : ( ord @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_HOL_Obool___Lattices_Osemilattice__inf_6,axiom,
    semilattice_inf @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_7,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Lattices_Olattice_8,axiom,
    lattice @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_9,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_10,axiom,
    ord @ $o @ ( type2 @ $o ) ).

%----Free types (1)
thf(tfree_0,hypothesis,
    linorder @ a @ ( type2 @ a ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( distinct @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ ( cons @ a @ x2 @ l2b ) ) )
    & ( linorder_sorted @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ ( cons @ a @ x2 @ l2b ) ) )
    & ( ( set2 @ a @ ( sorted2037043510sorted @ a @ ( cons @ a @ x1 @ l1a ) @ ( cons @ a @ x2 @ l2b ) ) )
      = ( inf_inf @ ( set @ a ) @ ( set2 @ a @ ( cons @ a @ x1 @ l1a ) ) @ ( set2 @ a @ ( cons @ a @ x2 @ l2b ) ) ) ) ) ).

%------------------------------------------------------------------------------
